#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// small planetMod01.fsh  by  Eseris
//https://www.shadertoy.com/view/3dtGR8
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
uniform int       iFrame; 

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

mat2 rot(float a) { return mat2(cos(a), sin(a), -sin(a), cos(a)); }

vec2 map(vec3 p) {
    float d = length(p) - 4.;
	return vec2(d, 1.);
}

vec3 calcNormal( in vec3 p ) {
    const float h = 1e-4;
    vec3 n = vec3(0.0);
    for(int i = min(iFrame,0); i<4; i++) {
        vec3 e = 0.5773*(2.0*vec3((((i+3)>>1)&1),((i>>1)&1),(i&1))-1.0);
        n += e*map(p+e*h).x;
    }
    return normalize(n);
}

vec2 rayProcess(vec3 camPos, vec3 rayDir, float start, float end) {
	float depth = start;
	for(int i = 0; i < 200; ++i) {
        vec3 p = camPos + depth * rayDir;
		vec2 dist = map(p);
		if(abs(dist.x) < 1e-3) return vec2(depth, dist.y);
		depth += dist.x;
		if(dist.x >= end) break;
	}
	return vec2(end, 0.);
}

vec3 getBgnd(vec3 d) {
    vec3 w = abs(d);
    w = pow(w, vec3(40.));
    w /= w.x + w.y + w.z;
    
    d *= 1.;
    vec3 col = vec3(0);
    col += w.x * texture2D(texture1, d.yz + .5).rgb;
    col += w.y * texture2D(texture1, d.zx + .5).rgb;
    col += w.z * texture2D(texture1, d.xy + .5).rgb;
    
    return col;
}

vec3 moonTexture(vec2 uv) {
    float d = length(fract(uv) - .5);
    //return exp(-40. * d * d) * vec3(1.);
    return texture2D(texture0, uv / 16.).rgb;
}

float heightmap(vec2 uv) {
    return .2 * moonTexture(uv).r;
}

vec3 normalmap(vec2 p) {
    vec2 e = vec2(1e-3, 0);
    return normalize(vec3(
        heightmap(p - e.xy) - heightmap(p + e.xy),
        heightmap(p - e.yx) - heightmap(p + e.yx),
        2. * e.x));
}

vec3 triplanarNormal(vec3 p, vec3 nor, vec3 w) {
    // compute rotation matrices for the 3 normal maps
    vec3 xrY = cross(nor, vec3(0,1,0));
    vec3 xrX = cross(xrY, nor);
    mat3 xrot = mat3(xrX, sign(nor.x) * xrY, nor);

    vec3 yrY = cross(nor, vec3(0,0,1));
    vec3 yrX = cross(yrY, nor);
    mat3 yrot = mat3(yrX, sign(nor.y) * xrY, nor);

    vec3 zrY = cross(nor, vec3(1,0,0));
    vec3 zrX = cross(zrY, nor);
    mat3 zrot = mat3(zrX, sign(nor.z) * xrY, nor);

    vec3 tnor = vec3(0);
    tnor += w.x * xrot * normalmap(p.yz + 5.);
    tnor += w.y * yrot * normalmap(p.zx + vec2(9., 14.));
    tnor += w.z * zrot * normalmap(p.xy + vec2(12., 7.));
    tnor = normalize(tnor);
    
    return tnor;
}

vec3 shading(vec3 ro, vec3 rd) {
    vec3 ld = normalize(vec3(.5, 1, -.7));
    vec3 sunCol = vec3(1, .8, .5);
    vec2 rp = rayProcess(ro, rd, 0., 40.);
    vec3 p = ro + rp.x * rd;
    
    vec3 col = vec3(0);
    if(rp.y >= 1.) {
        vec3 nor = calcNormal(p);
        
        vec3 w = pow(abs(nor), vec3(10.));
        w /= w.x + w.y + w.z;

        vec3 tnor = triplanarNormal(p, nor, w);
        vec3 mat = vec3(0);
        mat += w.x * moonTexture(p.yz + 5.);
        mat += w.y * moonTexture(p.zx + vec2(9., 14.));
        mat += w.z * moonTexture(p.xy + vec2(12., 7.));
        
        // lighting
        vec3 hal = normalize(ld - rd);
        float dif = max(dot(tnor, ld), 0.);
        
        // gspe is an atmospheric specular
        float spe = dot(nor, ld) * pow(max(dot(-rd, reflect(-ld, tnor)), 0.), 10.);
        float gspe = pow(max(dot(-rd, reflect(-ld, nor)) + .1, 0.), 7.);
        float cs = max(dot(ld, rd), 0.);
        
        col += mat * .01;
        col += mat *  dif * vec3(1., .9, .8);
        col += .6 * mix(spe, gspe, cs*cs) * sunCol;
        
        // simplfied fresnel
        float f = pow(1. - abs(dot(rd, nor)), 5.);
        col = mix(col, pow(getBgnd(reflect(rd, nor)), vec3(4.)), f);
        
    }
    else {
        // sky color
        col = pow(getBgnd(rd), vec3(6.));
        
        float ldot = clamp(dot(rd, ld) + .01, 0., 1.);
        float sun = pow(ldot, 200.);
        col = mix(col * pow(1. - ldot*ldot, 3.), sunCol, sun);
        //col += spe * vec3(.1, 0, 0);
    }
    
	return clamp(col, 0., 1.);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord - iResolution.xy / 2.) / iResolution.y;
    vec3 rd = normalize(vec3(uv, -1.07));

    vec2 ang = iMouse.xy / iResolution.xy;
    float yaw = 7. * ang.x + .2 * iTime;
    float pitch = -5. * ang.y + 1. + .07 * iTime;

    vec3 camPos = vec3(0., 0., 12);
    camPos.yz *= rot(pitch); camPos.zx *= rot(yaw);
    rd.yz     *= rot(pitch);     rd.zx *= rot(yaw);
    
    vec3 col = shading(camPos, rd);
    fragColor = vec4(pow(clamp(col, 0., 1.), vec3(.4545)), 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

